/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.carrot2.core.Cluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterWithParent {
    public final Cluster cluster;
    public final ClusterWithParent parent;
    public final List<ClusterWithParent> subclusters;

    private ClusterWithParent(ClusterWithParent parent, Cluster cluster, List<ClusterWithParent> subclusters) {
        if (cluster == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.cluster = cluster;
        this.subclusters = subclusters;
    }

    public static ClusterWithParent wrap(Cluster root) {
        return ClusterWithParent.wrap(null, root);
    }

    private static ClusterWithParent wrap(ClusterWithParent parent, Cluster root) {
        List<Cluster> actualSubclusters = root.getSubclusters();
        ArrayList subclustersWithParent = Lists.newArrayListWithExpectedSize((int)actualSubclusters.size());
        ClusterWithParent rootWithParent = new ClusterWithParent(parent, root, Collections.unmodifiableList(subclustersWithParent));
        for (Cluster actualCluster : actualSubclusters) {
            subclustersWithParent.add(ClusterWithParent.wrap(rootWithParent, actualCluster));
        }
        return rootWithParent;
    }

    public static List<ClusterWithParent> wrap(List<Cluster> clusters) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)clusters.size());
        for (Cluster cluster : clusters) {
            result.add(ClusterWithParent.wrap(cluster));
        }
        return result;
    }

    public static ClusterWithParent find(int id, Collection<ClusterWithParent> wrappers) {
        for (ClusterWithParent c : wrappers) {
            ClusterWithParent sub;
            if (c == null) continue;
            if (c.cluster.id != null && c.cluster.id == id) {
                return c;
            }
            if (c.cluster.getSubclusters().isEmpty() || (sub = ClusterWithParent.find(id, c.subclusters)) == null) continue;
            return sub;
        }
        return null;
    }

    public int hashCode() {
        return this.cluster == null ? 0 : this.cluster.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClusterWithParent) {
            return this.cluster.equals(((ClusterWithParent)obj).cluster);
        }
        return false;
    }
}

