/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.microsoft.AdultOption;
import org.carrot2.source.microsoft.MarketOption;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.httpclient.HttpHeaders;
import org.carrot2.util.httpclient.HttpUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.NamespaceList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="BingDocumentSource", inherit={CommonAttributes.class})
public final class BingDocumentSource
extends MultipageSearchEngine {
    public static final String CARROTSEARCH_APPID = "EFABBE1342FC43467F3CD65B1B83F450093B16B4";
    private static final Logger logger = LoggerFactory.getLogger(BingDocumentSource.class);
    private List<Header> HTTP_HEADERS = Arrays.asList(HttpHeaders.USER_AGENT_HEADER_MOZILLA);
    private static final int MAX_CONCURRENT_THREADS = 10;
    @Init
    @Input
    @Attribute
    @Required
    public String appid = "EFABBE1342FC43467F3CD65B1B83F450093B16B4";
    @Input
    @Processing
    @Attribute
    @Required
    public MarketOption market = MarketOption.ENGLISH_UNITED_STATES;
    @Processing
    @Input
    @Attribute
    public AdultOption adult;
    @Processing
    @Input
    @Attribute
    @Internal
    public String options = "DisableLocationDetection";
    @Processing
    @Input
    @Attribute
    @Internal
    public String webOptions;
    @Processing
    @Input
    @Attribute
    @Internal
    public String fileTypes;
    static final MultipageSearchEngineMetadata metadata = new MultipageSearchEngineMetadata(50, 1000);

    @Override
    public void process() throws ProcessingException {
        super.process(metadata, this.getSharedExecutor(10, this.getClass()));
    }

    @Override
    protected final Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange bucket) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(){

            public SearchEngineResponse search() throws Exception {
                return BingDocumentSource.this.doSearch(BingDocumentSource.this.query, bucket.start, bucket.results);
            }
        };
    }

    private final SearchEngineResponse doSearch(String query, int startAt, int totalResultsRequested) throws Exception {
        ArrayList params = Lists.newArrayList();
        params.add(new BasicNameValuePair("AppId", this.appid));
        params.add(new BasicNameValuePair("Query", query));
        params.add(new BasicNameValuePair("Sources", "Web"));
        params.add(new BasicNameValuePair("JsonType", "raw"));
        if (this.options != null) {
            params.add(new BasicNameValuePair("Options", this.options));
        }
        if (this.webOptions != null) {
            params.add(new BasicNameValuePair("Web.Options", this.webOptions));
        }
        if (this.fileTypes != null) {
            params.add(new BasicNameValuePair("Web.FileType", this.fileTypes));
        }
        params.add(new BasicNameValuePair("Web.Offset", Integer.toString(startAt)));
        params.add(new BasicNameValuePair("Web.Count", Integer.toString(totalResultsRequested)));
        params.add(new BasicNameValuePair("Market", this.market.marketCode));
        if (this.adult != null) {
            params.add(new BasicNameValuePair("Adult", this.adult.toString()));
        }
        String serviceURI = "http://api.bing.net/xml.aspx";
        HttpUtils.Response response = HttpUtils.doGET("http://api.bing.net/xml.aspx", params, this.HTTP_HEADERS);
        if (response.status == 200) {
            SearchEngineResponse ser = this.parseResponse(response.getPayloadAsStream());
            ser.metadata.put("compression", response.compression);
            if (logger.isDebugEnabled()) {
                logger.debug("Received, results: " + ser.results.size() + ", total: " + ser.getResultsTotal());
            }
            return ser;
        }
        String m = "Bing returned HTTP Error: " + response.status + ", HTTP payload: " + new String(response.payload, "iso8859-1");
        logger.warn(m);
        throw new IOException(m);
    }

    private SearchEngineResponse parseResponse(InputStream payloadAsStream) throws Exception {
        BingResponse response = (BingResponse)new Persister().read(BingResponse.class, payloadAsStream);
        SearchEngineResponse ser = new SearchEngineResponse();
        if (response.web != null && response.web.results != null) {
            ser.metadata.put("resultsTotal", response.web.total);
            LanguageCode langCode = this.market.toLanguageCode();
            for (WebResult wr : response.web.results) {
                Document doc = wr.toDocument();
                doc.setLanguage(langCode);
                ser.results.add(doc);
            }
        }
        return ser;
    }

    @Root(name="SearchResponse", strict=false)
    @NamespaceList(value={@Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/element"), @Namespace(prefix="web", reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")})
    public static class BingResponse {
        @org.simpleframework.xml.Attribute(name="Version", required=true)
        public String version;
        @ElementList(entry="SearchTerms", name="Query", required=false)
        public List<String> query;
        @Element(name="Web", required=false)
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        public WebResponse web;
    }

    @Root(name="Web", strict=false)
    public static class WebResponse {
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="Total", required=false)
        public long total;
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="Offset", required=false)
        public long offset;
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @ElementList(type=WebResult.class, name="Results", required=false)
        public List<WebResult> results;
    }

    @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
    @Root(name="WebResult", strict=false)
    public static class WebResult {
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="Title", required=false)
        public String title;
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="Description", required=false)
        public String description;
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="Url", required=false)
        public String url;
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="DisplayUrl", required=false)
        public String displayUrl;
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="CacheUrl", required=false)
        public String cacheUrl;
        @Namespace(reference="http://schemas.microsoft.com/LiveSearch/2008/04/XML/web")
        @Element(name="DateTime", required=false)
        public String dateTime;

        Document toDocument() {
            Document doc = new Document(this.title, this.description, this.url);
            doc.setField("click-url", this.displayUrl);
            return doc;
        }
    }
}

