/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.httpclient.HttpUtils;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.xslt.NopURIResolver;
import org.carrot2.util.xslt.TemplatesPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="XmlDocumentSourceHelper")
public class XmlDocumentSourceHelper {
    @Input
    @Processing
    @Attribute
    @IntRange(min=0, max=300)
    public int timeout = 8;
    private final TemplatesPool pool;
    private static final URIResolver uriResolver = new NopURIResolver();
    private static final Logger log = LoggerFactory.getLogger(XmlDocumentSourceHelper.class);

    public XmlDocumentSourceHelper() {
        try {
            this.pool = new TemplatesPool(false);
            this.pool.tFactory.setURIResolver(uriResolver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ProcessingResult loadProcessingResult(String url, Templates stylesheet, Map<String, String> xsltParameters, Map<String, Object> metadata, String user, String password) throws Exception {
        HttpUtils.Response response = HttpUtils.doGET(url, null, null, user, password, this.timeout * 1000);
        InputStream carrot2XmlStream = response.getPayloadAsStream();
        int statusCode = response.status;
        if (statusCode == 200) {
            metadata.put("compression", response.compression);
            return this.loadProcessingResult(carrot2XmlStream, stylesheet, xsltParameters);
        }
        throw new IOException("HTTP error, status code: " + statusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult loadProcessingResult(InputStream xml, Templates stylesheet, Map<String, String> xsltParameters) throws Exception {
        ProcessingResult processingResult;
        InputStream carrot2XmlStream = null;
        try {
            carrot2XmlStream = this.getCarrot2XmlStream(xml, stylesheet, xsltParameters);
            processingResult = ProcessingResult.deserialize(carrot2XmlStream);
        }
        catch (Throwable throwable) {
            CloseableUtils.close(carrot2XmlStream, xml);
            throw throwable;
        }
        CloseableUtils.close(carrot2XmlStream, xml);
        return processingResult;
    }

    private InputStream getCarrot2XmlStream(InputStream xmlInputStream, Templates stylesheet, Map<String, String> xsltParameters) throws TransformerConfigurationException, IOException, TransformerException {
        InputStream carrot2XmlInputStream;
        if (stylesheet != null) {
            byte[] debugInput = null;
            try {
                Transformer transformer = this.pool.newTransformer(stylesheet);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                if (xsltParameters != null) {
                    for (Map.Entry<String, String> entry : xsltParameters.entrySet()) {
                        transformer.setParameter(entry.getKey(), entry.getValue());
                    }
                }
                if (log.isDebugEnabled()) {
                    debugInput = StreamUtils.readFullyAndClose(xmlInputStream);
                    xmlInputStream = new ByteArrayInputStream(debugInput);
                }
                transformer.transform(new StreamSource(xmlInputStream), new StreamResult(outputStream));
                carrot2XmlInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (TransformerException e) {
                if (debugInput != null) {
                    log.debug("Transformer input: " + new String(debugInput, "UTF-8"));
                }
                throw e;
            }
            finally {
                CloseableUtils.close((Closeable)xmlInputStream);
            }
        } else {
            carrot2XmlInputStream = xmlInputStream;
        }
        return carrot2XmlInputStream;
    }

    public Templates loadXslt(IResource xslt) {
        InputStream is = null;
        try {
            is = xslt.open();
            Templates templates = this.pool.compileTemplate(is);
            return templates;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            CloseableUtils.close((Closeable)is);
        }
    }
}

