/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.ObjectOpenHashSet;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import java.util.List;
import org.carrot2.core.Document;
import org.carrot2.text.linguistic.LanguageModel;
import org.carrot2.text.util.MutableCharArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreprocessingContext {
    public static final ShortPredicate ON_DOCUMENT_SEPARATOR = PreprocessingContext.equalTo((short)512);
    public static final ShortPredicate ON_FIELD_SEPARATOR = PreprocessingContext.equalTo((short)1024);
    public static final ShortPredicate ON_SENTENCE_SEPARATOR = new ShortPredicate(){

        public boolean apply(short tokenType) {
            return (tokenType & 0x100) != 0;
        }
    };
    public final String query;
    public final List<Document> documents;
    public final LanguageModel language;
    public ObjectOpenHashSet<MutableCharArray> tokenCache = new ObjectOpenHashSet();
    public final AllTokens allTokens = new AllTokens();
    public final AllFields allFields = new AllFields();
    public final AllWords allWords = new AllWords();
    public final AllStems allStems = new AllStems();
    public AllPhrases allPhrases = new AllPhrases();
    public final AllLabels allLabels = new AllLabels();
    private static final int[][] bitsCache = new int[256][];

    public static final ShortPredicate equalTo(final short t) {
        return new ShortPredicate(){

            public boolean apply(short value) {
                return value == t;
            }
        };
    }

    public PreprocessingContext(LanguageModel languageModel, List<Document> documents, String query) {
        this.query = query;
        this.documents = documents;
        this.language = languageModel;
    }

    public boolean hasWords() {
        return this.allWords.image.length > 0;
    }

    public boolean hasLabels() {
        return this.allLabels.featureIndex != null && this.allLabels.featureIndex.length > 0;
    }

    public int[] toFieldIndexes(byte b) {
        return bitsCache[b & 0xFF];
    }

    public void preprocessingFinished() {
        this.tokenCache = null;
    }

    public char[] intern(MutableCharArray chs) {
        if (this.tokenCache.contains((Object)chs)) {
            return ((MutableCharArray)this.tokenCache.lget()).getBuffer();
        }
        char[] tokenImage = new char[chs.length()];
        System.arraycopy(chs.getBuffer(), chs.getStart(), tokenImage, 0, chs.length());
        this.tokenCache.add((Object)new MutableCharArray(tokenImage));
        return tokenImage;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PreprocessingContext.bitsCache[i] = new int[Integer.bitCount(i & 0xFF)];
            int v = 0;
            int bit = 0;
            int j = i & 0xFF;
            while (j != 0) {
                if ((j & 1) != 0) {
                    PreprocessingContext.bitsCache[i][v++] = bit;
                }
                j >>>= 1;
                ++bit;
            }
        }
    }

    public static class AllLabels {
        public int[] featureIndex;
        public BitSet[] documentIndices;
        public int firstPhraseIndex;
    }

    public static class AllPhrases {
        public int[][] wordIndices;
        public int[] tf;
        public int[][] tfByDocument;
    }

    public static class AllStems {
        public char[][] image;
        public int[] mostFrequentOriginalWordIndex;
        public int[] tf;
        public int[][] tfByDocument;
        public byte[] fieldIndices;
    }

    public static class AllWords {
        public char[][] image;
        public short[] type;
        public int[] tf;
        public int[][] tfByDocument;
        public int[] stemIndex;
        public byte[] fieldIndices;
    }

    public static class AllFields {
        public String[] name;
    }

    public static class AllTokens {
        public char[][] image;
        public short[] type;
        public byte[] fieldIndex;
        public int[] documentIndex;
        public int[] wordIndex;
        public int[] suffixOrder;
        public int[] lcp;
    }
}

