{* DO NOT EDIT THIS FILE! Use an override template instead. *}
{let page_limit=15
     package_list=fetch( package, list,
                         hash( offset, $view_parameters.offset,
                               limit, $page_limit,
                               repository_id, $repository_id ) )
     repository_list=fetch( package, repository_list )
     can_remove=fetch( package, can_remove )}
<form method="post" action={concat('package/list',
                            $view_parameters.offset|gt(0)
                            |choose('',
                                    concat('/offset/',$view_parameters.offset)))|ezurl}>

{section show=$remove_list}

<div class="warning">
<h2>{'Removal of packages'|i18n('design/standard/package')}</h2>
<p>{'Are you sure you want to remove the following packages?
The packages will be lost forever.
Note: The packages will not be uninstalled.'|i18n('design/standard/package')|break}</p>
<ul>
{section var=package loop=$remove_list}
    <li>
        <input type="hidden" name="PackageSelection[]" value="{$package.name|wash}" />
        {$package.name|wash} ({$package.summary|wash})
    </li>
{/section}
</ul>
</div>

<div class="buttonblock">
    <input class="button" type="submit" name="ConfirmRemovePackageButton" value="{'Confirm removal'|i18n('design/standard/package')}" />
    <input class="defaultbutton" type="submit" name="CancelRemovePackageButton" value="{'Keep packages'|i18n('design/standard/package')}" />
</div>

{section-else}

<h2>{'Packages'|i18n('design/standard/package')}</h2>

{if $module_action|eq( 'CancelRemovePackage' )}
<div class="feedback">
    <p>{'Package removal was canceled.'|i18n('design/standard/package')}</p>
</div>
{/if}


<p>{'The following packages are available on this system'|i18n('design/standard/package')}</p>

<label>{'Repositories'|i18n( 'design/standard/package' )}</label>
<select name="RepositoryID">
    <option value="">{'All'|i18n( 'design/standard/package' )}</option>
{section var=repository loop=$repository_list}
    <option value="{$repository.id|wash}"{if eq( $repository.id, $repository_id )} selected="selected"{/if}>{$repository.name|wash}</option>
{/section}
</select>
&nbsp;<input type="submit" name="ChangeRepositoryButton" value="{'Change repository'|i18n( 'design/standard/package' )}" />

<table class="list" width="100%" cellpadding="0" cellspacing="0" border="0">
<tr>
    {if $can_remove}
    <th width="1">{'Selection'|i18n('design/standard/package')}</th>
    {/if}
    <th>{'Name'|i18n('design/standard/package')}</th>
    <th>{'Version'|i18n('design/standard/package')}</th>
    <th>{'Summary'|i18n('design/standard/package')}</th>
    <th>{'Status'|i18n('design/standard/package')}</th>
</tr>
{section name=Package loop=$package_list sequence=array(bglight,bgdark)}
<tr class="{$:sequence}">
    {if $can_remove}
    <td width="1">{if $:item.is_local}<input type="checkbox" name="PackageSelection[]" value="{$:item.name|wash}" />{/if}</td>
    {/if}
    <td><a href={concat('package/view/full/',$:item.name)|ezurl}>{$:item.name|wash}</a></td>
    <td>{$:item.version-number}-{$:item.release-number}{if $:item.release-timestamp}({$:item.release-timestamp|l10n( shortdatetime )}){/if}{if $:item.type} [{$:item.type|wash}]{/if}</td>
    <td>{$:item.summary|wash}</td>
    <td>
        {if $:item.install_type|eq( 'install' )}
            {if $:item.is_installed}
                {'Installed'|i18n('design/standard/package')}
            {else}
                {'Not installed'|i18n('design/standard/package')}
            {/if}
        {else}
            {'Imported'|i18n('design/standard/package')}
        {/if}
    </td>
</tr>
{/section}
{if and( $package_list|gt( 0 ),
                   $can_remove )}
<tr>
    <td colspan="5">
    <div class="buttonblock">
        <input class="button" type="submit" name="RemovePackageButton" value="{'Remove package'|i18n('design/standard/package')}" />
    </div>
    </td>
</tr>
{/if}
</table>

{let can_create=fetch( package, can_create )
     can_import=fetch( package, can_import )}

<div class="buttonblock">
{if $can_import}
    <input class="button" type="submit" name="InstallPackageButton" value="{'Import package'|i18n('design/standard/package')}" />
{/if}
{if $can_create}
    <input class="button" type="submit" name="CreatePackageButton" value="{'Create package'|i18n('design/standard/package')}" />
{/if}
</div>

{/let}


{/section}


</form>

{/let}
