/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.etools;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBase;
import org.carrot2.util.StringUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.resource.ClassResource;
import org.carrot2.util.resource.IResource;

@Bindable(prefix="EToolsDocumentSource")
public class EToolsDocumentSource
extends RemoteXmlSimpleSearchEngineBase {
    @Input
    @Processing
    @Internal
    @Attribute
    public String serviceUrlBase = "http://www.etools.ch/partnerSearch.do";
    @Input
    @Processing
    @Attribute
    public Country country = Country.ALL;
    @Input
    @Processing
    @Attribute
    public Language language = Language.ENGLISH;
    @Input
    @Processing
    @Attribute
    @IntRange(min=0)
    public int timeout = 4000;
    @Input
    @Processing
    @Attribute
    public DataSources dataSources = DataSources.ALL;
    @Input
    @Processing
    @Attribute
    public boolean safeSearch = false;
    @Input
    @Processing
    @Attribute
    @Internal
    public String partnerId = "Carrot2";
    private static final int MAX_DATA_SOURCE_RESULTS = 40;
    private static final int FASTEST_SOURCES_COUNT = 5;
    private static final int ALL_SOURCES_COUNT = 10;

    protected IResource getXsltResource() {
        return new ClassResource(EToolsDocumentSource.class, "etools-to-c2.xsl");
    }

    protected String buildServiceUrl() {
        String urlBase = this.serviceUrlBase;
        if (urlBase.endsWith("/")) {
            urlBase = urlBase.substring(0, urlBase.length() - 1);
        }
        return urlBase + "?partner=" + this.partnerId + "&query=" + StringUtils.urlEncodeWrapException(this.query, "UTF-8") + "&dataSourceResults=" + Integer.toString(this.getDataSourceResultsCount()) + "&maxRecords=" + this.results + "&language=" + this.language.getCode() + "&timeout=" + Integer.toString(this.timeout) + "&dataSources=" + this.dataSources.getCode() + "&safeSearch=" + Boolean.toString(this.safeSearch) + "&country=" + this.country.getCode();
    }

    int getDataSourceResultsCount() {
        int sources;
        int n = sources = DataSources.ALL.equals((Object)this.dataSources) ? 10 : 5;
        if (this.results == 0) {
            return 0;
        }
        int rawDataSourceResults = this.results / sources;
        return Math.min(((rawDataSourceResults + 9) / 10 + 1) * 10, 40);
    }

    protected void afterFetch(SearchEngineResponse response) {
        for (Document document : response.results) {
            document.setLanguage(this.language.toLanguageCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataSources {
        ALL("all"),
        FASTEST("fastest");

        private String code;

        private DataSources(String code) {
            this.code = code;
        }

        public String toString() {
            return StringUtils.identifierToHumanReadable(this.name());
        }

        public String getCode() {
            return this.code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Language {
        ALL("all"),
        ENGLISH("en"),
        FRENCH("fr"),
        GERMAN("de"),
        ITALIAN("it"),
        SPANISH("es");

        private static final Map<Language, LanguageCode> TO_LANGUAGE_CODE;
        private String code;

        private Language(String code) {
            this.code = code;
        }

        public String toString() {
            return StringUtils.identifierToHumanReadable(this.name());
        }

        public String getCode() {
            return this.code;
        }

        public LanguageCode toLanguageCode() {
            return TO_LANGUAGE_CODE.get((Object)this);
        }

        static {
            EnumMap map = Maps.newEnumMap(Language.class);
            map.put(ENGLISH, LanguageCode.ENGLISH);
            map.put(FRENCH, LanguageCode.FRENCH);
            map.put(GERMAN, LanguageCode.GERMAN);
            map.put(ITALIAN, LanguageCode.ITALIAN);
            map.put(SPANISH, LanguageCode.SPANISH);
            TO_LANGUAGE_CODE = Collections.unmodifiableMap(map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Country {
        ALL("web"),
        AUSTRIA("AT"),
        FRANCE("FR"),
        GERMANY("DE"),
        GREAT_BRITAIN("GB"),
        ITALY("IT"),
        LICHTENSTEIN("LI"),
        SPAIN("ES"),
        SWITZERLAND("CH");

        private String code;

        private Country(String code) {
            this.code = code;
        }

        public String toString() {
            return StringUtils.identifierToHumanReadable(this.name());
        }

        public String getCode() {
            return this.code;
        }
    }
}

