/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.carrot2.core.ComponentInitializationException;
import org.carrot2.core.ControllerUtils;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ReferenceEquality;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.Pair;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeBindingException;
import org.carrot2.util.attribute.BindableUtils;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.pool.IActivationListener;
import org.carrot2.util.pool.IDisposalListener;
import org.carrot2.util.pool.IInstantiationListener;
import org.carrot2.util.pool.IParameterizedPool;
import org.carrot2.util.pool.IPassivationListener;
import org.carrot2.util.pool.SoftUnboundedPool;
import org.carrot2.util.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingProcessingComponentManager
implements IProcessingComponentManager {
    private IControllerContext context;
    private volatile IParameterizedPool<IProcessingComponent, String> componentPool;
    private Map<String, Object> initAttributes;
    private Map<String, ProcessingComponentConfiguration> componentIdToConfiguration;
    private ConcurrentHashMap<Pair<Class<? extends IProcessingComponent>, String>, Map<String, Object>> initOutputAttributes = new ConcurrentHashMap();

    public PoolingProcessingComponentManager() {
        this(new SoftUnboundedPool<IProcessingComponent, String>());
    }

    public PoolingProcessingComponentManager(IParameterizedPool<IProcessingComponent, String> componentPool) {
        this.componentPool = componentPool;
        ComponentResetListener componentResetListener = new ComponentResetListener();
        componentPool.init(new ComponentInstantiationListener(), componentResetListener, componentResetListener, ComponentDisposalListener.INSTANCE);
    }

    @Override
    public void init(IControllerContext context, Map<String, Object> attributes, ProcessingComponentConfiguration ... configurations) {
        assert (context != null);
        if (this.context != null) {
            throw new IllegalStateException("This manager has already been initialized.");
        }
        this.context = context;
        this.initAttributes = Maps.newHashMap(attributes);
        this.componentIdToConfiguration = ProcessingComponentConfiguration.indexByComponentId(configurations);
    }

    @Override
    public IProcessingComponent prepare(Class<? extends IProcessingComponent> clazz, String id, Map<String, Object> inputAttributes, Map<String, Object> outputAttributes) {
        try {
            IProcessingComponent component = this.componentPool.borrowObject(clazz, id);
            Map<String, Object> initOutputAttrs = this.initOutputAttributes.get(new Pair(component.getClass(), id));
            if (initOutputAttrs != null) {
                outputAttributes.putAll(initOutputAttrs);
            }
            return component;
        }
        catch (InstantiationException e) {
            throw new ComponentInitializationException("Could not instantiate component class: " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ComponentInitializationException("Could not instantiate component class: " + clazz.getName(), e);
        }
    }

    @Override
    public void recycle(IProcessingComponent component, String id) {
        this.componentPool.returnObject(component, id);
    }

    @Override
    public void dispose() {
        this.componentPool.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentResetListener
    implements IPassivationListener<IProcessingComponent, String>,
    IActivationListener<IProcessingComponent, String> {
        private ConcurrentHashMap<ReferenceEquality, Map<String, Object>> resetValues = new ConcurrentHashMap();

        private ComponentResetListener() {
        }

        @Override
        public void activate(IProcessingComponent processingComponent, String parameter) {
            HashMap originalValues = Maps.newHashMap();
            try {
                AttributeBinder.get(processingComponent, originalValues, Input.class, Processing.class);
                this.resetValues.put(new ReferenceEquality(processingComponent), originalValues);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not unbind attribute values", e);
            }
        }

        @Override
        public void passivate(IProcessingComponent processingComponent, String parameter) {
            try {
                AttributeBinder.set(processingComponent, this.resetValues.get(new ReferenceEquality(processingComponent)), false, Input.class, Processing.class);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not reset attribute values", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentDisposalListener
    implements IDisposalListener<IProcessingComponent, String> {
        static final ComponentDisposalListener INSTANCE = new ComponentDisposalListener();

        private ComponentDisposalListener() {
        }

        @Override
        public void dispose(IProcessingComponent component, String parameter) {
            component.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NonPrimitiveInputAttributesCheck
    implements AttributeBinder.IAttributeBinderAction {
        static boolean makeAssertion = false;
        private static final Logger log = LoggerFactory.getLogger(NonPrimitiveInputAttributesCheck.class);
        static final Set<Class<?>> ALLOWED_PLAIN_TYPES = ImmutableSet.of(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, (Object[])new Class[]{Double.class, Character.class, File.class, String.class, Calendar.class, Date.class});
        static final Set<Class<?>> ALLOWED_ASSIGNABLE_TYPES = ImmutableSet.of(Enum.class, IResource.class, Collection.class, Map.class);
        static final Set<String> ALLOWED_PLAIN_TYPES_BY_NAME = ImmutableSet.of((Object)"org.apache.lucene.store.FSDirectory", (Object)"org.apache.lucene.store.RAMDirectory", (Object)"org.apache.lucene.store.MMapDirectory", (Object)"org.apache.lucene.store.SimpleFSDirectory", (Object)"org.apache.lucene.store.SimpleFSDirectory");
        private final Map<String, Object> values;

        NonPrimitiveInputAttributesCheck(Map<String, Object> values) {
            this.values = values;
        }

        @Override
        public void performAction(AttributeBinder.BindingTracker bindingTracker, int level, Object object, Field field, Object fieldValue, Predicate<Field> predicate) throws InstantiationException {
            String key = BindableUtils.getKey(field);
            Object value = this.values.get(key);
            if (value == null || Class.class.isInstance(value) || Proxy.isProxyClass(value.getClass()) || value.getClass().getAnnotation(ThreadSafe.class) != null) {
                return;
            }
            Class<?> valueType = value.getClass();
            if (!(ALLOWED_PLAIN_TYPES.contains(valueType) || ALLOWED_PLAIN_TYPES_BY_NAME.contains(valueType.getName()) || NonPrimitiveInputAttributesCheck.isAllowedAssignableType(valueType))) {
                log.info("An object of a non-@ThreadSafe class " + valueType.getName() + " bound at initialization-time to attribute " + key + ". Make sure this is intended.");
                if (makeAssertion) assert (false) : "An object of a non-@ThreadSafe class " + valueType.getName() + " bound at initialization-time to attribute " + key + ". Make sure this intended.";
            }
        }

        private static boolean isAllowedAssignableType(Class<?> attributeType) {
            for (Class<?> clazz : ALLOWED_ASSIGNABLE_TYPES) {
                if (!clazz.isAssignableFrom(attributeType)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ComponentInstantiationListener
    implements IInstantiationListener<IProcessingComponent, String> {
        private ComponentInstantiationListener() {
        }

        @Override
        public void objectInstantiated(IProcessingComponent component, String parameter) {
            try {
                HashMap initAttrs = Maps.newHashMap((Map)PoolingProcessingComponentManager.this.initAttributes);
                if (parameter != null) {
                    initAttrs.putAll(((ProcessingComponentConfiguration)((PoolingProcessingComponentManager)PoolingProcessingComponentManager.this).componentIdToConfiguration.get((Object)parameter)).attributes);
                }
                HashMap initOutputAttrs = Maps.newHashMap();
                this.checkNonPrimitiveInstances(component, initAttrs, new AttributeBinder.AllAnnotationsPresentPredicate(Input.class, Init.class));
                ControllerUtils.init(component, initAttrs, initOutputAttrs, false, PoolingProcessingComponentManager.this.context);
                PoolingProcessingComponentManager.this.initOutputAttributes.putIfAbsent(new Pair(component.getClass(), parameter), ImmutableMap.copyOf((Map)initOutputAttrs));
                try {
                    Predicate<Field> predicate = new Predicate<Field>(){

                        public boolean apply(Field field) {
                            return field.getAnnotation(Input.class) != null && field.getAnnotation(Processing.class) != null && field.getAnnotation(Init.class) == null;
                        }
                    };
                    this.checkNonPrimitiveInstances(component, initAttrs, predicate);
                    AttributeBinder.set((Object)component, (Map<String, Object>)initAttrs, false, predicate);
                }
                catch (AttributeBindingException e) {
                    throw new ComponentInitializationException("Could not initialize component", e);
                }
                catch (InstantiationException e) {
                    throw new ComponentInitializationException("Could not initialize component", e);
                }
            }
            catch (Exception e) {
                component.dispose();
                throw ExceptionUtils.wrapAs(ComponentInitializationException.class, e);
            }
        }

        void checkNonPrimitiveInstances(IProcessingComponent processingComponent, Map<String, Object> inputAttributes, Predicate<Field> predicate) throws InstantiationException {
            AttributeBinder.bind((Object)processingComponent, new AttributeBinder.IAttributeBinderAction[]{new NonPrimitiveInputAttributesCheck(inputAttributes)}, predicate);
        }
    }
}

