/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.xsltfilter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

final class DeferredOutputStream
extends ServletOutputStream {
    private OutputStream passthroughStream;
    private IOException nextException;
    protected boolean closed = false;
    protected ByteArrayOutputStream deferredOutput = new ByteArrayOutputStream();

    public byte[] getBytes() {
        if (!this.closed) {
            throw new IllegalStateException("Stream must be closed to acquire buffered data.");
        }
        if (this.passthroughStream != null) {
            throw new IllegalStateException("All buffered data passed to the delegate stream already.");
        }
        return this.deferredOutput.toByteArray();
    }

    public void close() throws IOException {
        this.checkPendingExceptions();
        if (this.passthroughStream != null) {
            this.passthroughStream.close();
        }
        this.closed = true;
    }

    public void flush() throws IOException {
        this.checkPendingExceptions();
        if (this.passthroughStream != null) {
            this.passthroughStream.flush();
        }
    }

    public void write(int b) throws IOException {
        this.checkPendingExceptions();
        if (this.passthroughStream != null) {
            this.passthroughStream.write(b);
        } else {
            this.deferredOutput.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.checkPendingExceptions();
        if (this.passthroughStream != null) {
            this.passthroughStream.write(b);
        } else {
            this.deferredOutput.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkPendingExceptions();
        if (this.passthroughStream != null) {
            this.passthroughStream.write(b, off, len);
        } else {
            this.deferredOutput.write(b, off, len);
        }
    }

    protected final void passthrough(OutputStream stream) {
        byte[] writtenSoFar = this.deferredOutput.toByteArray();
        this.deferredOutput = null;
        try {
            stream.write(writtenSoFar);
        }
        catch (IOException e) {
            this.nextException = e;
        }
        this.passthroughStream = stream;
    }

    protected void setExceptionOnNext(IOException e) {
        this.nextException = e;
    }

    private final void checkPendingExceptions() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.nextException != null) {
            throw this.nextException;
        }
    }
}

